/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.canvas.process;

import filenet.vw.apps.designer.VWDesignerCoreData;
import filenet.vw.apps.designer.VWSolutionHelper;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.VWDesignerPreferences;
import filenet.vw.toolkit.design.canvas.process.IVWProcessCanvasPanel;
import filenet.vw.toolkit.design.canvas.resources.VWResource;
import filenet.vw.toolkit.design.property.VWAuthPropertyData;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.event.IVWToolbarActionListener;
import filenet.vw.toolkit.utils.event.VWToolbarActionEvent;
import java.awt.ComponentOrientation;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;

public class VWProcessActionMenu
implements ActionListener,
IVWToolbarActionListener {
    private JMenuItem m_processPropertiesItem = null;
    private JMenuItem m_gotoMapItem = null;
    private JMenuItem m_validateProcessItem = null;
    private JMenuItem m_transferProcessItem = null;
    private JMenuItem m_launchProcessItem = null;
    private JMenuItem m_setMainProcessItem = null;
    private JMenuItem m_saveProcessToLocalItem = null;
    private JMenuItem m_saveProcessToRepositoryItem = null;
    private JMenuItem m_printSetupItem = null;
    private JMenuItem m_printPreviewItem = null;
    private JMenuItem m_printProcessItem = null;
    private JMenuItem m_removeProcessItem = null;
    private JMenuItem m_examineReferencesItem = null;
    private IVWProcessCanvasPanel m_processCanvasPanel = null;
    private VWDesignerCoreData m_designerCoreData = null;

    public VWProcessActionMenu(IVWProcessCanvasPanel processCanvasPanel) {
        this.m_processCanvasPanel = processCanvasPanel;
        this.m_designerCoreData = this.m_processCanvasPanel.getAuthPropertyData().getDesignerCoreData();
        this.m_processCanvasPanel.getAuthPropertyData().getToolbarActionNotifier().addToolbarActionListener(this);
    }

    public void initializeMenu(JMenu actionMenu) {
        if (actionMenu == null) {
            return;
        }
        int nMenuShortcutKeyMask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        if (this.m_designerCoreData.getApplicationMode() == 1) {
            this.m_processPropertiesItem = VWStringUtils.getMenuItemUsingString(VWResource.s_menuWorkflowProperties_withHK);
            if (this.m_processPropertiesItem != null) {
                this.m_processPropertiesItem.addActionListener(this);
                actionMenu.add(this.m_processPropertiesItem);
            }
            actionMenu.add(new JSeparator());
        }
        this.m_gotoMapItem = VWStringUtils.getMenuItemUsingString(VWResource.s_menuGotoMap_withHK);
        if (this.m_gotoMapItem != null) {
            this.m_gotoMapItem.addActionListener(this);
            actionMenu.add(this.m_gotoMapItem);
        }
        actionMenu.add(new JSeparator());
        VWSolutionHelper solutionHelper = this.m_designerCoreData.getSolutionHelper();
        if (this.m_designerCoreData.getApplicationMode() == 1) {
            this.m_validateProcessItem = VWStringUtils.getMenuItemUsingString(VWResource.s_menuValidateWorkflow_withHK);
            if (this.m_validateProcessItem != null) {
                this.m_validateProcessItem.addActionListener(this);
                actionMenu.add(this.m_validateProcessItem);
            }
            if (solutionHelper == null) {
                this.m_transferProcessItem = VWStringUtils.getMenuItemUsingString(VWResource.s_menuTransferWorkflow_withHK);
                if (this.m_transferProcessItem != null) {
                    this.m_transferProcessItem.addActionListener(this);
                    actionMenu.add(this.m_transferProcessItem);
                }
                this.m_launchProcessItem = VWStringUtils.getMenuItemUsingString(VWResource.s_menuLaunchWorkflow_withHK);
                if (this.m_launchProcessItem != null) {
                    this.m_launchProcessItem.addActionListener(this);
                    actionMenu.add(this.m_launchProcessItem);
                }
            }
            actionMenu.add(new JSeparator());
        }
        String workflowName = this.m_processCanvasPanel.getAuthPropertyData().getWorkflowDefinition().getName();
        boolean bIsMainWorkflow = this.m_designerCoreData.getProcessMenuHelper().isMainProcessName(workflowName);
        if (!bIsMainWorkflow) {
            this.m_setMainProcessItem = VWStringUtils.getMenuItemUsingString(VWResource.s_menuSetAsMainWorkflow_withHK);
            if (this.m_setMainProcessItem != null) {
                this.m_setMainProcessItem.addActionListener(this);
                actionMenu.add(this.m_setMainProcessItem);
            }
        }
        if (solutionHelper == null) {
            this.m_saveProcessToLocalItem = VWStringUtils.getMenuItemUsingString(VWResource.s_menuSaveWorkflowToLocal_withHK);
            if (this.m_saveProcessToLocalItem != null) {
                this.m_saveProcessToLocalItem.addActionListener(this);
                actionMenu.add(this.m_saveProcessToLocalItem);
            }
            this.m_saveProcessToRepositoryItem = VWStringUtils.getMenuItemUsingString(VWResource.s_menuSaveWorkflowToRespository_withHK);
            if (this.m_saveProcessToRepositoryItem != null) {
                this.m_saveProcessToRepositoryItem.addActionListener(this);
                actionMenu.add(this.m_saveProcessToRepositoryItem);
            }
            actionMenu.add(new JSeparator());
        } else if (!bIsMainWorkflow) {
            actionMenu.add(new JSeparator());
        }
        this.m_printSetupItem = VWStringUtils.getMenuItemUsingString(VWResource.s_menuPrintSetup_withHK);
        if (this.m_printSetupItem != null) {
            this.m_printSetupItem.addActionListener(this);
            actionMenu.add(this.m_printSetupItem);
        }
        this.m_printPreviewItem = VWStringUtils.getMenuItemUsingString(VWResource.s_menuPrintPreview_withHK);
        if (this.m_printPreviewItem != null) {
            this.m_printPreviewItem.addActionListener(this);
        }
        this.m_printProcessItem = VWStringUtils.getMenuItemUsingString(VWResource.s_menuPrintWorkflow_withHK);
        if (this.m_printProcessItem != null) {
            this.m_printProcessItem.setAccelerator(KeyStroke.getKeyStroke(80, nMenuShortcutKeyMask));
            this.m_printProcessItem.addActionListener(this);
            actionMenu.add(this.m_printProcessItem);
        }
        if (!bIsMainWorkflow) {
            actionMenu.add(new JSeparator());
            this.m_removeProcessItem = VWStringUtils.getMenuItemUsingString(VWResource.s_menuRemoveWorkflow_withHK);
            if (this.m_removeProcessItem != null) {
                this.m_removeProcessItem.addActionListener(this);
                actionMenu.add(this.m_removeProcessItem);
            }
        }
        if (this.m_designerCoreData.getSessionInfo().getDisplayP8BPMFunctionality()) {
            actionMenu.add(new JSeparator());
            this.m_examineReferencesItem = VWStringUtils.getMenuItemUsingString(VWResource.s_menuExamineReferences_withHK);
            if (this.m_examineReferencesItem != null) {
                this.m_examineReferencesItem.addActionListener(this);
                actionMenu.add(this.m_examineReferencesItem);
            }
        }
        actionMenu.applyComponentOrientation(ComponentOrientation.getOrientation(Locale.getDefault()));
    }

    public void releaseReferences() {
        this.m_processPropertiesItem = null;
        this.m_gotoMapItem = null;
        this.m_validateProcessItem = null;
        this.m_transferProcessItem = null;
        this.m_launchProcessItem = null;
        this.m_setMainProcessItem = null;
        this.m_saveProcessToLocalItem = null;
        this.m_saveProcessToRepositoryItem = null;
        this.m_printSetupItem = null;
        this.m_printPreviewItem = null;
        this.m_printProcessItem = null;
        this.m_removeProcessItem = null;
        this.m_examineReferencesItem = null;
        this.m_processCanvasPanel = null;
        this.m_designerCoreData = null;
    }

    public void actionPerformed(ActionEvent event) {
        Object object = event.getSource();
        if (object == this.m_processPropertiesItem) {
            this.performWorkflowPropertiesItemAction();
        } else if (object == this.m_gotoMapItem) {
            this.performGotoMapAction();
        } else if (object == this.m_validateProcessItem) {
            if (!this.m_processCanvasPanel.getTabbedCanvasPanel().saveConfigurationChanges(false)) {
                return;
            }
            this.m_designerCoreData.getProcessMenuHelper().validateProcess(this.m_processCanvasPanel.getAuthPropertyData(), true);
        } else if (object == this.m_transferProcessItem) {
            if (!this.m_processCanvasPanel.getTabbedCanvasPanel().saveConfigurationChanges(true)) {
                return;
            }
            this.m_designerCoreData.getProcessMenuHelper().transferProcess(this.m_processCanvasPanel.getAuthPropertyData(), true);
        } else if (object == this.m_launchProcessItem) {
            if (!this.m_processCanvasPanel.getTabbedCanvasPanel().saveConfigurationChanges(true)) {
                return;
            }
            this.m_designerCoreData.getProcessMenuHelper().launchProcess(this.m_processCanvasPanel.getAuthPropertyData());
        } else if (object == this.m_setMainProcessItem) {
            this.m_designerCoreData.getProcessMenuHelper().setMainProcess(this.m_processCanvasPanel.getAuthPropertyData().getWorkflowDefinition().getName());
        } else if (object == this.m_saveProcessToLocalItem) {
            this.m_designerCoreData.getProcessMenuHelper().saveProcessToLocal(this.m_processCanvasPanel.getAuthPropertyData().getWorkflowDefinition().getName());
        } else if (object == this.m_saveProcessToRepositoryItem) {
            this.m_designerCoreData.getProcessMenuHelper().saveProcessToRepository(this.m_processCanvasPanel.getAuthPropertyData().getWorkflowDefinition().getName());
        } else if (object == this.m_printSetupItem) {
            this.m_processCanvasPanel.getTabbedCanvasPanel().performPrintSetup();
        } else if (object == this.m_printPreviewItem) {
            this.m_processCanvasPanel.getTabbedCanvasPanel().performPrintPreview();
        } else if (object == this.m_printProcessItem) {
            this.performPrintSelectedItemAction(object);
        } else if (object == this.m_removeProcessItem) {
            this.m_designerCoreData.getProcessMenuHelper().removeProcess(this.m_processCanvasPanel.getAuthPropertyData().getWorkflowDefinition().getName(), true);
        } else if (object == this.m_examineReferencesItem) {
            this.performExamineReferencesItemAction();
        }
    }

    public void toolbarActionPerformed(VWToolbarActionEvent event) {
        switch (event.getID()) {
            case 650: {
                this.m_designerCoreData.getProcessMenuHelper().validateProcessCollection(this, true);
                break;
            }
            case 651: {
                this.performValidateSelectedItemAction();
                break;
            }
            case 655: {
                this.performExamineReferencesItemAction();
            }
        }
    }

    private void performWorkflowPropertiesItemAction() {
        if (this.m_processCanvasPanel != null) {
            this.m_processCanvasPanel.displayWorkflowProperties();
        }
    }

    private void performGotoMapAction() {
        if (this.m_processCanvasPanel.getWorkflowPane() != null) {
            this.m_processCanvasPanel.getWorkflowPane().showGotoMapDialog();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performValidateSelectedItemAction() {
        if (this.m_processCanvasPanel == null) {
            return;
        }
        try {
            try {
                this.m_processCanvasPanel.displayWaitCursor();
                VWAuthPropertyData authPropertyData = this.m_processCanvasPanel.getAuthPropertyData();
                this.m_designerCoreData.getProcessMenuHelper().validateProcess(authPropertyData, true);
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                Object var3_4 = null;
                this.m_processCanvasPanel.restoreDefaultCursor();
            }
            Object var3_3 = null;
            this.m_processCanvasPanel.restoreDefaultCursor();
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            this.m_processCanvasPanel.restoreDefaultCursor();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performPrintSelectedItemAction(Object sourceObject) {
        if (this.m_processCanvasPanel == null) {
            return;
        }
        try {
            try {
                this.m_processCanvasPanel.displayWaitCursor();
                VWAuthPropertyData authPropertyData = this.m_processCanvasPanel.getAuthPropertyData();
                this.m_designerCoreData.getProcessMenuHelper().printProcess(authPropertyData, sourceObject == this.m_printProcessItem);
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                Object var4_5 = null;
                this.m_processCanvasPanel.restoreDefaultCursor();
            }
            Object var4_4 = null;
            this.m_processCanvasPanel.restoreDefaultCursor();
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this.m_processCanvasPanel.restoreDefaultCursor();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean performExamineReferencesItemAction() {
        try {
            boolean bValid;
            this.m_processCanvasPanel.displayWaitCursor();
            boolean bIsInheritanceEnabled = false;
            VWDesignerPreferences designerPrefs = this.m_designerCoreData.getDesignerPreferences();
            if (designerPrefs != null) {
                bIsInheritanceEnabled = designerPrefs.getShouldDisplayInheritedInformation();
            }
            VWAuthPropertyData authPropertyData = this.m_processCanvasPanel.getAuthPropertyData();
            boolean bl = bValid = this.m_designerCoreData.getProcessMenuHelper().examineReferences(authPropertyData, bIsInheritanceEnabled);
            Object var7_7 = null;
            this.m_processCanvasPanel.restoreDefaultCursor();
            return bl;
        }
        catch (Exception ex) {
            try {
                VWDebug.logException(ex);
                Object var7_8 = null;
                this.m_processCanvasPanel.restoreDefaultCursor();
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                this.m_processCanvasPanel.restoreDefaultCursor();
                throw throwable;
            }
        }
        return false;
    }
}

